import pickle
import pandas as pd
from sklearn import linear_model
import numpy as np

# Random seed
RANDOM_STATE_INT = 1234
np.random.seed(RANDOM_STATE_INT)

# Create dataset
dataset = pd.DataFrame({
    "account_balance": map(round, list(np.random.uniform(-10000, high=200000, size=50))),
    "credit_amount": map(round, list(np.random.uniform(200000, high=1000000, size=50))),
    "most_valuable_available_asset": map(round, list(np.random.uniform(0, high=700000, size=50))),
    "target": list(np.random.choice([0, 1], size=(50,), p=[3./4, 1./4])),
})
# Train model
model = linear_model.LogisticRegression()
model.fit(X = dataset.drop(columns = ['target']), y = dataset['target'])

# Save model to .pkl
with open(file = "model.pkl", mode = 'wb') as model_file:
    pickle.dump(model, model_file)
	
print("Model have been successfully trained and saved!")